-- ----------------------------
-- Table structure for eb_system_role
-- ----------------------------
DROP TABLE IF EXISTS `eb_system_role`;
CREATE TABLE `eb_system_role`  (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT '身份管理id',
  `role_name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '身份管理名称',
  `rules` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '身份管理权限(menus_id)',
  `level` tinyint(3) UNSIGNED NOT NULL DEFAULT 0,
  `status` tinyint(1) UNSIGNED NOT NULL DEFAULT 1 COMMENT '状态',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `status`(`status`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 8 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '身份管理表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of eb_system_role
-- ----------------------------
INSERT INTO `eb_system_role` VALUES (1, '超级管理员', '267,42,43,175,176,318,319,320,321,322,44,558,127,323,324,325,128,328,329,331,333,45,46,335,337,338,339,340,341,47,48,345,346,347,348,349,350,49,357,358,559,162,351,352,353,356,164,363,364,366,561,56,57,367,368,369,372,562,58,113,114,115,373,374,141,171,172,375,376,377,173,174,381,382,383,385,387,139,583,118,119,158,397,398,159,402,123,160,161,459,460,678,461,676,492,493,680,494,495,496,679,497,586,587,588,146,147,148,669,464,465,466,467,468,563,564,469,470,452,317,450,632,633,636,637,634,635,51,80,552,505,547,548,549,550,551,553,554,555,556,52,53,408,409,410,54,403,404,405,540,55,541,542,543,544,546,602,603,605,670,607,608,671,604,672,593,594,595,596,597,598,665,666,667,668,66,528,581,67,68,69,432,433,434,437,438,439,250,442,443,444,582,609,610,612', 0, 1, '2020-04-18 11:19:25', '2021-08-14 11:27:57');
INSERT INTO `eb_system_role` VALUES (4, '门店核销', '452,317,450,51,165,166,417,418,419,167,420,421,422,578,579,580,168,425,426,427,169', 1, 1, '2021-02-04 14:05:27', '2021-07-17 10:57:04');
INSERT INTO `eb_system_role` VALUES (5, '演示站', '267,42,43,175,44,558,127,323,128,328,333,45,46,337,47,48,346,349,350,49,357,162,351,356,164,366,561,56,57,367,372,562,58,113,114,115,141,171,172,375,173,174,387,139,140,396,316,393,118,119,158,397,398,159,402,123,160,161,459,460,461,492,493,494,495,496,497,146,147,148,464,465,466,467,468,563,469,470,452,317,450,51,80,505,547,52,53,408,54,403,55,541,542,129,130,565,566,131,572,573,576,577,132,165,166,417,167,578,168,425,169,66,528,67,68,69,432,437,250,442', 1, 1, '2021-02-25 15:34:57', '2021-02-25 15:34:57');
INSERT INTO `eb_system_role` VALUES (6, '管理员', '267,42,43,175,176,318,319,320,321,322,44,558,127,323,324,325,128,328,329,331,333,45,46,335,337,338,339,340,341,47,48,345,346,347,348,349,350,49,357,358,559,162,351,352,353,356,164,363,364,366,561,113,114,115,373,374,141,171,172,375,376,377,173,174,381,382,383,385,387,139,140,389,390,392,396,316,393,583,118,119,158,397,398,159,402,123,160,161,459,460,461,492,493,494,495,496,497,146,147,148,464,465,466,467,468,563,564,469,470,452,317,450,66,528,581,67,69,432,433,434,437,438,439', 1, 1, '2021-04-20 15:04:27', '2021-04-20 15:04:27');





-- ----------------------------
-- Table structure for eb_category
-- ----------------------------
DROP TABLE IF EXISTS `eb_category`;
CREATE TABLE `eb_category`  (
  `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `pid` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '父级ID',
  `path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '/0/' COMMENT '路径',
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '分类名称',
  `type` smallint(2) NULL DEFAULT 1 COMMENT '类型，1 产品分类，2 附件分类，3 文章分类， 4 设置分类， 5 菜单分类，6 配置分类， 7 秒杀配置',
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT '' COMMENT '地址',
  `extra` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL COMMENT '扩展字段 Jsos格式',
  `status` tinyint(1) NOT NULL DEFAULT 1 COMMENT '状态, 1正常，0失效',
  `sort` int(5) NOT NULL DEFAULT 99999 COMMENT '排序',
  `create_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP(0) COMMENT '更新时间',
  PRIMARY KEY (`id`) USING BTREE,
  INDEX `status+pid`(`pid`, `status`) USING BTREE,
  INDEX `id+status+url`(`path`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 637 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '分类表' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of eb_category
-- ----------------------------

INSERT INTO `eb_category` (`id`, `pid`, `path`, `name`, `type`, `url`, `extra`, `status`, `sort`, `create_time`, `update_time`)
VALUES
	(42,0,'/0/','商品',5,'/store','s-goods',1,1,'2020-04-28 17:03:34','2020-08-12 12:29:13'),
	(43,42,'/0/42/','商品管理',5,'/store/index',NULL,1,1,'2020-04-28 17:04:20','2020-08-12 12:29:13'),
	(44,42,'/0/42/','商品分类',5,'/store/sort',NULL,1,1,'2020-04-28 17:04:40','2020-08-12 12:29:13'),
	(45,0,'/0/','订单',5,'/order','s-order',1,1,'2020-04-28 17:04:56','2020-08-12 12:29:13'),
	(46,45,'/0/45/','订单',5,'/order/index','s-order',1,1,'2020-04-28 17:05:17','2021-02-04 10:12:41'),
	(47,0,'/0/','用户',5,'/user','user-solid',1,1,'2020-04-28 17:05:53','2020-08-12 12:29:13'),
	(48,47,'/0/47/','用户管理',5,'/user/index',NULL,1,1,'2020-04-28 17:07:13','2020-08-12 12:29:13'),
	(49,47,'/0/47/','用户标签',5,'/user/label',NULL,1,1,'2020-04-28 17:42:21','2020-08-12 12:29:13'),
	(51,0,'/0/','设置',5,'/operation','s-tools',1,-9,'2020-05-06 09:40:14','2020-08-12 12:29:13'),
	(52,51,'/0/51/','管理权限',5,'/operation/roleManager',NULL,1,1,'2020-05-06 09:40:35','2020-08-12 12:29:13'),
	(53,52,'/0/51/52/','身份管理',5,'/operation//roleManager/identityManager',NULL,1,1,'2020-05-06 09:40:51','2020-08-12 12:29:13'),
	(54,52,'/0/51/52/','管理员列表',5,'/operation//roleManager/adminList',NULL,1,1,'2020-05-06 09:41:11','2020-08-12 12:29:13'),
	(55,52,'/0/51/52/','权限规则',5,'/operation//roleManager/promiseRules',NULL,1,1,'2020-05-06 09:41:46','2020-08-12 12:29:13'),
	(56,0,'/0/','内容',5,'/content','s-management',1,1,'2020-05-07 12:00:33','2020-08-12 12:29:13'),
	(57,56,'/0/56/','文章管理',5,'/content/articleManager',NULL,1,1,'2020-05-07 12:02:39','2020-08-12 12:29:13'),
	(58,56,'/0/56/','文章分类',5,'/content/classifManager',NULL,1,1,'2020-05-07 12:02:46','2020-08-12 12:29:13'),
	(66,0,'/0/','维护',5,'/maintain','s-open',1,-10,'2020-05-09 16:02:05','2020-08-12 12:29:13'),
	(67,66,'/0/66/','开发配置',5,'/maintain//devconfiguration',NULL,1,0,'2020-05-09 16:06:46','2020-08-12 12:29:13'),
	(68,67,'/0/66/67/','配置分类',5,'/maintain/devconfiguration/configCategory',NULL,1,0,'2020-05-09 16:07:09','2020-08-12 12:29:13'),
	(69,67,'/0/66/67/','组合数据',5,'/maintain/devconfiguration/combineddata',NULL,1,0,'2020-05-09 16:08:00','2020-08-12 12:29:13'),
	(80,51,'/0/51/','系统设置',5,'/operation/setting',NULL,1,9,'2020-05-20 09:44:47','2020-12-10 11:30:07'),
	(81,0,'/0/','PC管理后台配置',6,'基础配置','64',1,1,'2020-05-20 10:02:57','2021-08-25 12:11:34'),
	(93,81,'/0/81/','站点配置',6,'站点配置','64',1,1,'2020-05-21 11:04:20','2020-08-12 12:29:13'),
	(94,100,'/0/100/','客服配置',6,'云智服','76',1,1,'2020-05-21 11:04:37','2020-09-09 17:09:47'),
	(95,0,'/0/','商城配置',6,'商城配置','77',1,2,'2020-05-21 11:10:20','2020-08-12 12:29:13'),
	(96,95,'/0/95/','商城基础配置',6,'商城基础配置','77',1,1,'2020-05-21 11:10:40','2020-08-12 12:29:13'),
	(98,95,'/0/95/','小票打印配置',6,'小票打印配置','75',0,1,'2020-05-21 11:11:11','2020-08-13 14:07:02'),
	(99,95,'/0/95/','充值配置',6,'充值配置','78',1,1,'2020-05-21 11:11:28','2020-08-12 12:29:13'),
	(100,0,'/0/','应用配置',6,'应用配置',NULL,1,1,'2020-05-21 12:31:49','2020-08-12 12:29:13'),
	(101,100,'/0/100/','公众号配置',6,'公众号配置','65',1,1,'2020-05-21 12:32:07','2020-08-12 12:29:13'),
	(102,100,'/0/100/','小程序配置',6,'小程序配置','66',1,1,'2020-05-21 12:32:18','2020-08-12 12:29:13'),
	(103,0,'/0/','支付配置',6,'支付配置',NULL,1,1,'2020-05-21 12:33:36','2020-08-12 12:29:13'),
	(104,103,'/0/103/','公众号支付配置',6,'公众号支付配置','67',1,1,'2020-05-21 12:33:54','2020-08-12 12:29:13'),
	(105,103,'/0/103/','小程序支付配置',6,'小程序支付配置','68',1,1,'2020-05-21 12:34:36','2020-08-12 12:29:13'),
	(106,103,'/0/103/','线下支付',6,'线下支付','79',0,1,'2020-05-21 12:34:48','2021-03-09 17:39:19'),
	(107,103,'/0/103/','余额支付',6,'余额支付','80',1,1,'2020-05-21 12:35:01','2020-08-12 12:29:13'),
	(108,0,'/0/','文件上传配置',6,'文件上传配置',NULL,1,1,'2020-05-21 12:35:16','2020-08-12 12:29:13'),
	(109,108,'/0/108/','基础配置',6,'基础配置','108',1,1,'2020-05-21 12:35:28','2020-09-14 10:33:54'),
	(110,108,'/0/108/','阿里云配置',6,'阿里云配置','81',1,1,'2020-05-21 12:36:01','2020-08-12 12:29:13'),
	(111,108,'/0/108/','七牛云配置',6,'七牛云配置','82',1,1,'2020-05-21 12:36:12','2020-08-12 12:29:13'),
	(112,108,'/0/108/','腾讯云配置',6,'腾讯云配置','83',1,1,'2020-05-21 12:36:22','2020-08-12 12:29:13'),
	(113,0,'/0/','应用',5,'/appSetting','s-promotion',1,1,'2020-05-21 16:12:53','2020-08-12 12:29:13'),
	(114,113,'/0/113/','公众号',5,'/appSetting/publicAccount',NULL,1,1,'2020-05-21 16:13:18','2020-08-12 12:29:13'),
	(115,114,'/0/113/114/','微信菜单',5,'/appSetting//publicAccount/wxMenus',NULL,1,1,'2020-05-21 16:13:36','2020-08-12 12:29:13'),
	(118,0,'/0/','营销',5,'/marketing','s-marketing',1,1,'2020-05-25 14:39:52','2020-08-12 12:29:13'),
	(119,118,'/0/118/','优惠券',5,'/marketing/coupon',NULL,1,1,'2020-05-25 14:40:13','2020-08-12 12:29:13'),
	(123,118,'/0/118/','积分',5,'/marketing/integral',NULL,1,1,'2020-05-25 14:41:33','2020-08-12 12:29:13'),
	(127,42,'/0/42/','商品规格',5,'/store/attr',NULL,1,1,'2020-05-25 18:12:11','2020-08-12 12:29:13'),
	(128,42,'/0/42/','商品评论',5,'/store/comment',NULL,1,1,'2020-05-27 10:16:30','2020-08-12 12:29:13'),
	(139,113,'/0/113/','小程序',5,'/appSetting/publicRoutine',NULL,1,1,'2020-06-05 09:56:17','2020-08-12 12:29:13'),
	(140,139,'/0/113/139/','我的模板',5,'/appSetting/publicRoutine/routineTemplate',NULL,0,1,'2020-06-05 09:56:58','2021-03-08 12:05:24'),
	(141,114,'/0/113/114/','自动回复',5,'/appSetting/publicAccount/wxReply',NULL,1,1,'2020-06-15 16:15:32','2020-08-12 12:29:13'),
	(146,0,'/0/','分销',5,'/distribution','s-check',1,1,'2020-07-18 16:31:09','2020-12-07 09:35:02'),
	(147,146,'/0/146/','分销员管理',5,'/distribution/index',NULL,1,1,'2020-07-18 16:31:49','2020-12-18 10:22:25'),
	(148,146,'/0/146/','分销配置',5,'/distribution/distributionconfig',NULL,1,1,'2020-07-18 16:32:06','2020-12-18 10:22:19'),
	(158,119,'/0/118/119/','优惠券',5,'/marketing/coupon/list',NULL,1,1,'2020-07-24 16:13:10','2020-08-29 10:15:34'),
	(159,119,'/0/118/119/','会员领取记录',5,'/marketing/coupon/record',NULL,1,1,'2020-07-24 16:13:37','2020-08-12 12:29:13'),
	(160,123,'/0/118/123/','积分配置',5,'/marketing/integral/integralconfig',NULL,1,1,'2020-07-24 16:14:48','2020-08-12 12:29:13'),
	(161,123,'/0/118/123/','积分日志',5,'/marketing/integral/integrallog',NULL,1,1,'2020-07-24 16:15:11','2020-08-12 12:29:13'),
	(162,47,'/0/47/','用户等级',5,'/user/grade',NULL,1,1,'2020-07-24 16:21:48','2020-08-12 12:29:13'),
	(164,47,'/0/47/','用户分组',5,'/user/group',NULL,1,1,'2020-07-24 16:22:46','2020-08-12 12:29:13'),
	(171,141,'/0/113/114/141/','微信关注回复',5,'/appSetting/publicAccount/wxReply/follow',NULL,1,1,'2020-07-24 16:42:52','2020-08-12 12:29:13'),
	(172,141,'/0/113/114/141/','关键字回复',5,'/appSetting/publicAccount/wxReply/keyword',NULL,1,1,'2020-07-24 16:43:09','2020-08-12 12:29:13'),
	(173,141,'/0/113/114/141/','无效关键词回复',5,'/appSetting/publicAccount/wxReply/replyIndex',NULL,1,1,'2020-07-24 16:43:23','2020-08-12 12:29:13'),
	(174,114,'/0/113/114/','微信模板',5,'/appSetting//publicAccount/template',NULL,1,1,'2020-07-24 16:43:52','2020-08-29 10:05:10'),
	(175,43,'/0/42/43/','商品添加',5,'api/admin/store/product/save',NULL,0,1,'2020-07-24 16:46:04','2020-08-31 10:07:27'),
	(176,43,'/0/42/43/','商品修改',5,'api/admin/store/product/update',NULL,0,1,'2020-07-24 16:46:19','2020-08-31 10:07:24'),
	(245,0,'/0/272/','热门推荐',1,'','crmebimage/store/2021/02/25/061463374f084111bd1ea7ff8efb9e6f9q6z7246xp.jpg',1,0,'2020-08-12 11:42:27','2021-02-25 19:42:12'),
	(246,245,'/0/272/245/','新品上市',1,'www','crmebimage/store/2020/08/13/95e065018ba24172b2e2dd2e2833360coobdzkt671.png',1,0,'2020-08-12 11:42:58','2021-01-25 10:04:18'),
	(248,245,'/0/272/245/','热卖商品',1,'www','crmebimage/store/2020/08/13/29b418bf2543477d8417a85e779e6d79clby7stw86.png',1,0,'2020-08-12 11:50:40','2021-01-25 10:04:16'),
	(250,67,'/0/66/67/','表单配置',5,'/maintain/devconfiguration/formConfig',NULL,1,0,'2020-08-12 12:09:56','2020-08-12 12:29:13'),
	(258,245,'/0/272/245/','折扣专区',1,'www','crmebimage/store/2020/08/13/1826c7f20771444e888501d91332f129wik43qfgmw.png',1,0,'2020-08-12 13:59:31','2021-01-25 10:04:12'),
	(267,0,'/0/','控制台',5,'/dashboard','menu',1,10,'2020-08-13 10:31:07','2021-02-04 11:04:27'),
	(268,0,'/0/','图标素材',2,'url',NULL,0,1,'2020-08-13 10:36:08','2020-08-13 10:36:08'),
	(270,0,'/0/','banner',2,'url',NULL,0,1,'2020-08-13 11:35:39','2020-08-13 11:35:39'),
	(271,0,'/0/','分类素材',2,'url',NULL,0,1,'2020-08-13 11:46:28','2020-08-13 11:46:28'),
	(272,0,'/0/','家用电器',1,'','crmebimage/store/2020/08/13/88dfb08327f7470d8285613aa1bd9ab3xk2qzolbad.png',1,0,'2020-08-13 12:03:40','2021-02-02 18:44:56'),
	(273,272,'/0/272/','电视',1,'','crmebimage/store/2020/08/13/15e36da884e44f91939a92468d0c848fxftnm6thvc.png',1,0,'2020-08-13 12:05:23','2021-01-25 10:02:40'),
	(274,272,'/0/272/','冰箱',1,'www','crmebimage/store/2020/08/13/0c1fb92238ce4f67b9c2cb03c9c932c8a28451t0g7.png',1,0,'2020-08-13 12:06:47','2021-01-25 10:02:42'),
	(275,272,'/0/272/','洗衣机',1,'www','crmebimage/store/2020/08/13/6f722314cefa418fada5eab9e09bf86aqutumxihsx.png',1,0,'2020-08-13 12:07:57','2021-01-25 10:02:45'),
	(276,272,'/0/272/','生活电器',1,'','crmebimage/store/2020/08/13/df0f8dfb34c1424abde8737039c5f58b1acdgq3h7w.png',1,0,'2020-08-13 12:11:36','2021-01-25 10:02:47'),
	(277,272,'/0/272/','厨卫电器',1,'','crmebimage/store/2020/08/13/cb007f931afb4386bfff7f80b8971203c5qc2k1j1n.png',1,0,'2020-08-13 12:12:38','2021-01-25 10:02:50'),
	(279,272,'/0/272/','清凉一夏',1,'','crmebimage/store/2020/08/13/306ee4383bbf460494e8b3368782a076ugnezzb362.png',1,0,'2020-08-13 12:15:11','2021-01-25 10:02:53'),
	(280,0,'/0/','家装家具',1,'','crmebimage/store/2020/08/14/547bfd86471b412eb4f163e07cfc2027uzzul0xoyl.jpg',1,0,'2020-08-13 12:17:25','2021-07-05 19:08:19'),
	(281,0,'/0/','户外出行',1,'','crmebimage/content/2020/08/14/d992711f08ae45369ec1bd56a30c462880pnyxs5xg.jpg',1,0,'2020-08-13 12:17:54','2021-07-05 19:08:20'),
	(282,0,'/0/','美妆个护',1,'','crmebimage/store/2021/02/25/afbfa9719ca648ca97d158c79e9cad793ln7e5a7jb.jpg',1,0,'2020-08-13 12:18:04','2021-02-25 19:44:34'),
	(283,0,'/0/','3C数码',1,'','crmebimage/store/2021/02/25/d165ef5cac704798b05e29de0c2f4e69boxn0l2n7f.jpg',1,0,'2020-08-13 12:18:14','2021-02-25 19:44:05'),
	(284,0,'/0/283/','日用文创',1,'','crmebimage/store/2021/02/25/cdf7aa541f1c4d5f9a442947091fe3612d6e0rtzx9.jpg',1,0,'2020-08-13 12:18:30','2021-02-25 19:43:34'),
	(285,280,'/0/280/','智能门锁',1,'','crmebimage/store/2020/08/13/f4f47201c43e42ac82b83ed711199774ggihs7g6yb.png',1,0,'2020-08-13 13:31:48','2021-01-25 10:03:09'),
	(286,280,'/0/280/','居家照明',1,'','crmebimage/store/2020/08/13/f0771d0db94847bbb2cb60ebe5201aa0tzzjzor6d5.png',1,0,'2020-08-13 13:33:06','2021-01-25 10:03:12'),
	(287,280,'/0/280/','家装建材',1,'','crmebimage/store/2020/08/13/4209c46356f4478ea3ed2b8adfc8dd4d4udgw8nsig.png',1,0,'2020-08-13 13:34:22','2021-01-25 10:03:15'),
	(288,281,'/0/281/','健身运动',1,'','crmebimage/store/2020/08/13/183bae2de334412f8593325805bb45e07xvwxc6nbn.png',1,0,'2020-08-13 13:35:37','2021-01-25 10:03:20'),
	(289,281,'/0/281/','户外装备',1,'','crmebimage/store/2020/08/13/767c7e25f56543f398e11896d356b46a1t4l6k8qk0.png',1,0,'2020-08-13 13:36:34','2021-01-25 10:03:22'),
	(290,281,'/0/281/','骑行配件',1,'','crmebimage/store/2020/08/13/8525ef6066a04537aa5ee92234dc2edcf1iyqm9gq9.png',1,0,'2020-08-13 13:37:23','2021-01-25 10:03:25'),
	(291,282,'/0/282/','美妆工具',1,'','crmebimage/store/2020/08/13/57f108bff43744c88323c666d77cac72g4p0a23tpo.png',1,0,'2020-08-13 13:38:32','2021-02-25 19:44:37'),
	(292,282,'/0/282/','口腔清洁',1,'','crmebimage/store/2020/08/13/72f39322b33249e0b3441908e3b657b2rzf7g4x37c.png',1,0,'2020-08-13 13:39:33','2021-02-25 19:44:38'),
	(293,282,'/0/282/','彩妆香氛',1,'','crmebimage/store/2020/08/13/bf981c370d9d44f998803310fedb8af3yr9suwbwp1.png',1,0,'2020-08-13 13:40:34','2021-02-25 19:44:39'),
	(294,282,'/0/282/','面部护肤',1,'','crmebimage/store/2020/08/13/59a066f8bb5145cbada4b7a08965cf15b26idurig9.png',1,0,'2020-08-13 13:42:19','2021-02-25 19:44:39'),
	(295,282,'/0/282/','身体护理',1,'','crmebimage/store/2020/08/13/769f2ba251114a75bc3da94166770482zv3tb4ogjy.png',1,0,'2020-08-13 13:43:21','2021-02-25 19:44:40'),
	(296,282,'/0/282/','其他工具',1,'','crmebimage/store/2020/08/13/5c9d8b4b4a2e4fc782558787fc941e24o6u5iv52dl.png',1,0,'2020-08-13 13:44:15','2021-02-25 19:44:41'),
	(297,283,'/0/283/','手机',1,'','crmebimage/store/2020/08/13/3a985dc276b941c093a12332500d9784ce3bed9l0c.png',1,0,'2020-08-13 13:45:52','2021-01-25 10:03:45'),
	(298,283,'/0/283/','平板电脑',1,'','crmebimage/store/2020/08/13/5771a123b9a24666b5cdcf531f7744d6grduvuarjw.png',1,0,'2020-08-13 13:46:22','2021-01-25 10:03:47'),
	(299,283,'/0/283/','数码配件',1,'','crmebimage/store/2020/08/13/760282c126c74ff7a335c3efd6bb2e27vduh9zraqs.png',1,0,'2020-08-13 13:47:16','2021-01-25 10:03:50'),
	(300,284,'/0/284/','日用杂货',1,'','crmebimage/store/2020/08/13/ba82799518704655ab2fdc254336de08wtb2ofda96.png',1,0,'2020-08-13 13:48:30','2021-01-25 10:03:53'),
	(301,284,'/0/284/','纸品湿巾',1,'','crmebimage/store/2020/08/13/eb7a947539d94cd495ea6493e37a3e35lkqmcnnl9q.png',1,0,'2020-08-13 13:49:30','2021-01-25 10:03:56'),
	(302,284,'/0/284/','办公文具',1,'','crmebimage/store/2020/08/13/a84efcfa299c4269af95d671e122d4770vrq87ttfz.png',1,0,'2020-08-13 13:50:39','2021-01-25 10:03:58'),
	(303,0,'/0/','产品',2,'url',NULL,0,1,'2020-08-13 13:53:11','2020-08-13 13:53:11'),
	(306,283,'/0/283/','小米笔记本',1,'','crmebimage/store/2020/08/14/547bfd86471b412eb4f163e07cfc2027uzzul0xoyl.jpg',1,0,'2020-08-14 14:19:04','2021-01-25 10:04:03'),
	(316,139,'/0/113/139/','公共模板',5,'/appSetting/publicRoutine/publicRoutineTemplate',NULL,0,1,'2020-08-27 14:15:41','2021-03-08 12:05:27'),
	(317,452,'/0/452/','订单核销',5,'/javaMobile/orderCancellation',NULL,1,0,'2020-08-27 14:51:47','2020-09-12 15:19:51'),
	(318,43,'/0/42/43/','商品删除',5,'api/admin/store/product/delete',NULL,0,0,'2020-08-28 16:12:53','2020-08-31 10:07:24'),
	(319,43,'/0/42/43/','商品上架',5,'api/admin/store/product/putOnShell',NULL,0,0,'2020-08-28 16:14:14','2020-08-31 10:07:22'),
	(320,43,'/0/42/43/','商品下架',5,'api/admin/store/product/offShell',NULL,0,0,'2020-08-28 16:14:33','2020-08-31 10:07:23'),
	(321,43,'/0/42/43/','库存变动',5,'api/admin/store/product/stock',NULL,0,0,'2020-08-28 16:15:07','2020-08-31 10:07:21'),
	(322,43,'/0/42/43/','虚拟销量',5,'api/admin/store/product/ficti',NULL,0,0,'2020-08-28 16:15:59','2020-08-31 10:07:21'),
	(323,127,'/0/42/127/','规格添加',5,'api/admin/store/product/rule/save',NULL,0,0,'2020-08-28 16:25:25','2020-08-28 16:26:44'),
	(324,127,'/0/42/127/','规格修改',5,'api/admin/store/product/rule/update',NULL,0,0,'2020-08-28 16:25:40','2021-02-04 12:16:35'),
	(325,127,'/0/42/127/','规格删除',5,'api/admin/store/product/rule/delete',NULL,0,0,'2020-08-28 16:26:01','2021-02-04 15:19:41'),
	(328,128,'/0/42/128/','商品评论添加',5,'api/admin/store/product/reply/save',NULL,0,0,'2020-08-28 16:27:53','2020-08-28 16:27:53'),
	(329,128,'/0/42/128/','商品评论修改',5,'api/admin/store/product/reply/update',NULL,0,0,'2020-08-28 16:28:18','2020-08-28 16:28:18'),
	(331,128,'/0/42/128/','商品评论删除',5,'api/admin/store/product/reply/delete',NULL,0,0,'2020-08-28 16:29:57','2020-08-28 16:30:02'),
	(333,128,'/0/42/128/','商品评论回复',5,'api/admin/store/product/reply/comment',NULL,0,0,'2020-08-28 16:30:38','2020-08-28 16:30:38'),
	(335,46,'/0/45/46/','订单删除',5,'api/admin/store/order/delete',NULL,0,0,'2020-08-29 09:33:49','2020-08-29 09:33:49'),
	(337,46,'/0/45/46/','订单标记',5,'api/admin/store/order/mark',NULL,0,0,'2020-08-29 09:34:25','2020-08-29 09:34:25'),
	(338,46,'/0/45/46/','订单退款',5,'api/admin/store/order/refund',NULL,0,0,'2020-08-29 09:34:38','2020-08-29 09:34:38'),
	(339,46,'/0/45/46/','订单拒绝退款',5,'api/admin/store/order/refund/refuse',NULL,0,0,'2020-08-29 09:35:08','2020-08-29 09:35:08'),
	(340,46,'/0/45/46/','订单发货',5,'api/admin/store/order/send',NULL,0,0,'2020-08-29 09:35:33','2020-08-29 09:35:33'),
	(341,46,'/0/45/46/','订单更新',5,'api/admin/store/order/update',NULL,0,0,'2020-08-29 09:35:44','2020-08-29 09:35:44'),
	(345,48,'/0/47/48/','用户修改',5,'api/admin/user/update',NULL,0,0,'2020-08-29 09:39:12','2020-08-29 09:39:12'),
	(346,48,'/0/47/48/','用户详情',5,'api/admin/user/infobycondition',NULL,0,0,'2020-08-29 09:39:22','2020-08-29 09:41:16'),
	(347,48,'/0/47/48/','用户分组',5,'api/admin/user/group',NULL,0,0,'2020-08-29 09:39:31','2020-08-29 09:39:31'),
	(348,48,'/0/47/48/','用户删除',5,'api/admin/user/delete',NULL,0,0,'2020-08-29 09:39:49','2020-08-29 09:39:49'),
	(349,48,'/0/47/48/','用户打标签',5,'api/admin/user/tag',NULL,0,0,'2020-08-29 09:40:02','2020-08-29 09:40:02'),
	(350,48,'/0/47/48/','修改积分余额',5,'api/admin/user/operate/founds',NULL,0,0,'2020-08-29 09:41:50','2020-08-29 09:41:50'),
	(351,162,'/0/47/162/','用户等级添加',5,'api/admin/system/user/level/save',NULL,0,0,'2020-08-29 09:43:32','2020-08-29 09:44:47'),
	(352,162,'/0/47/162/','用户等级修改',5,'api/admin/system/user/level/update',NULL,0,0,'2020-08-29 09:46:00','2020-08-29 09:46:00'),
	(353,162,'/0/47/162/','用户等级删除',5,'api/admin/system/user/level/delete',NULL,0,0,'2020-08-29 09:46:13','2020-08-29 09:46:13'),
	(356,162,'/0/47/162/','用户等级是否显示',5,'api/admin/system/user/level/use',NULL,0,0,'2020-08-29 09:47:41','2020-08-29 09:47:41'),
	(357,49,'/0/47/49/','用户标签添加',5,'api/admin/user/tag/save',NULL,0,0,'2020-08-29 09:48:13','2020-08-29 09:49:20'),
	(358,49,'/0/47/49/','用户标签修改',5,'api/admin/user/tag/update',NULL,0,0,'2020-08-29 09:48:26','2020-08-29 09:49:27'),
	(363,164,'/0/47/164/','用户分组修改',5,'api/admin/user/group/update',NULL,0,0,'2020-08-29 09:52:23','2020-08-29 09:52:23'),
	(364,164,'/0/47/164/','用户分组删除',5,'api/admin/user/group/delete',NULL,0,0,'2020-08-29 09:52:35','2020-08-29 09:52:35'),
	(366,164,'/0/47/164/','用户分组列表',5,'api/admin/user/group/list',NULL,0,0,'2020-08-29 09:53:09','2020-08-29 09:53:09'),
	(367,57,'/0/56/57/','文章添加',5,'api/admin/article/save',NULL,0,0,'2020-08-29 09:54:14','2020-08-29 09:54:14'),
	(368,57,'/0/56/57/','文章删除',5,'api/admin/article/delete',NULL,0,0,'2020-08-29 09:55:05','2020-08-29 09:55:05'),
	(369,57,'/0/56/57/','文章修改',5,'api/admin/article/update',NULL,0,0,'2020-08-29 09:55:15','2020-08-29 09:55:15'),
	(372,57,'/0/56/57/','文章绑定产品',5,'api/admin/article/bind/product',NULL,0,0,'2020-08-29 09:56:40','2020-08-29 09:56:40'),
	(373,115,'/0/113/114/115/','微信菜单保存',5,'api/admin/wechat/menu/public/create',NULL,0,0,'2020-08-29 09:59:41','2020-08-29 09:59:41'),
	(374,115,'/0/113/114/115/','微信菜单删除',5,'api/admin/wechat/menu/public/delete',NULL,0,0,'2020-08-29 10:00:02','2020-08-29 10:00:02'),
	(375,172,'/0/113/114/141/172/','关键字添加',5,'api/admin/wechat/keywords/reply/save',NULL,0,0,'2020-08-29 10:02:20','2020-08-29 10:02:20'),
	(376,172,'/0/113/114/141/172/','关键字删除',5,'api/admin/wechat/keywords/reply/delete',NULL,0,0,'2020-08-29 10:02:48','2020-08-29 10:02:48'),
	(377,172,'/0/113/114/141/172/','关键字修改',5,'api/admin/wechat/keywords/reply/update',NULL,0,0,'2020-08-29 10:03:00','2020-08-29 10:03:00'),
	(381,174,'/0/113/114/174/','微信模板添加',5,'api/admin/wechat/template/save',NULL,0,0,'2020-08-29 10:05:03','2020-08-29 10:06:14'),
	(382,174,'/0/113/114/174/','微信模板修改',5,'api/admin/wechat/template/update',NULL,0,0,'2020-08-29 10:05:35','2020-08-29 10:06:19'),
	(383,174,'/0/113/114/174/','微信模板删除',5,'api/admin/wechat/template/delete',NULL,0,0,'2020-08-29 10:05:44','2020-08-29 10:06:24'),
	(385,174,'/0/113/114/174/','微信模板状态更新',5,'api/admin/wechat/template/status',NULL,0,0,'2020-08-29 10:06:55','2020-08-29 10:06:55'),
	(387,174,'/0/113/114/174/','微信模板行业信息',5,'api/admin/wechat/template/industry',NULL,0,0,'2020-08-29 10:07:32','2020-08-29 10:07:32'),
	(389,140,'/0/113/139/140/','我的模板添加',5,'api/admin/wechat/program/my/temp/save',NULL,0,0,'2020-08-29 10:08:31','2020-08-29 10:08:31'),
	(390,140,'/0/113/139/140/','我的模板修改',5,'api/admin/wechat/program/my/temp/update',NULL,0,0,'2020-08-29 10:08:41','2020-08-29 10:08:41'),
	(392,140,'/0/113/139/140/','我的模板状态更新',5,'api/admin/wechat/program/my/temp/status',NULL,0,0,'2020-08-29 10:09:44','2020-08-29 10:09:44'),
	(393,316,'/0/113/139/316/','公共模板行业信息',5,'api/admin/wechat/program/category',NULL,0,0,'2020-08-29 10:10:28','2020-08-29 10:10:28'),
	(396,140,'/0/113/139/140/','根据公共模板获取关键词列表',5,'api/admin/wechat/program/getWeChatKeywordsByTid',NULL,0,0,'2020-08-29 10:11:56','2020-08-29 10:11:56'),
	(397,158,'/0/118/119/158/','优惠券添加',5,'api/admin/marketing/coupon/save',NULL,0,0,'2020-08-29 10:12:37','2020-08-29 10:16:13'),
	(398,158,'/0/118/119/158/','优惠券状态更新',5,'api/admin/marketing/coupon/update/status',NULL,0,0,'2020-08-29 10:13:10','2020-08-29 10:16:20'),
	(402,159,'/0/118/119/159/','领取优惠券',5,'api/admin/marketing/coupon/user/receive',NULL,0,0,'2020-08-29 10:18:21','2020-08-29 10:18:48'),
	(403,54,'/0/51/52/54/','管理员添加',5,'api/admin/system/admin/save',NULL,0,0,'2020-08-29 10:22:43','2020-08-29 10:26:11'),
	(404,54,'/0/51/52/54/','管理员修改',5,'api/admin/system/admin/update',NULL,0,0,'2020-08-29 10:23:00','2020-08-29 10:26:09'),
	(405,54,'/0/51/52/54/','管理员删除',5,'api/admin/system/admin/delete',NULL,0,0,'2020-08-29 10:23:11','2020-08-29 10:26:06'),
	(408,53,'/0/51/52/53/','身份添加',5,'api/admin/system/role/save',NULL,0,0,'2020-08-29 10:26:52','2020-08-29 10:26:52'),
	(409,53,'/0/51/52/53/','身份删除',5,'api/admin/system/role/delete',NULL,0,0,'2020-08-29 10:27:07','2020-08-29 10:27:07'),
	(410,53,'/0/51/52/53/','身份修改',5,'api/admin/system/role/update',NULL,0,0,'2020-08-29 10:27:27','2020-08-29 10:27:27'),
	(432,69,'/0/66/67/69/','数据组添加',5,'api/admin/system/group/save',NULL,0,0,'2020-08-29 10:41:33','2020-08-29 10:41:33'),
	(433,69,'/0/66/67/69/','数据组修改',5,'api/admin/system/group/update',NULL,0,0,'2020-08-29 10:41:49','2020-08-29 10:41:49'),
	(434,69,'/0/66/67/69/','数据组删除',5,'api/admin/system/group/delete',NULL,0,0,'2020-08-29 10:41:59','2020-08-29 10:41:59'),
	(437,69,'/0/66/67/69/','组合数据添加',5,'api/admin/system/group/data/save',NULL,0,0,'2020-08-29 10:43:00','2020-08-29 10:43:00'),
	(438,69,'/0/66/67/69/','组合数据修改',5,'api/admin/system/group/data/update',NULL,0,0,'2020-08-29 10:43:16','2020-08-29 10:43:16'),
	(439,69,'/0/66/67/69/','组合数据删除',5,'api/admin/system/group/data/delete',NULL,0,0,'2020-08-29 10:43:41','2020-08-29 10:43:41'),
	(442,250,'/0/66/67/250/','表单添加',5,'api/admin/system/form/temp/save',NULL,0,0,'2020-08-29 10:45:23','2020-08-29 10:45:23'),
	(443,250,'/0/66/67/250/','表单删除',5,'api/admin/system/form/temp/delete',NULL,0,0,'2020-08-29 10:45:40','2020-08-29 10:45:40'),
	(444,250,'/0/66/67/250/','表单修改',5,'api/admin/system/form/temp/update',NULL,0,0,'2020-08-29 10:46:06','2020-08-29 10:46:06'),
	(450,452,'/0/452/','订单统计',5,'/javaMobile/orderStatistics',NULL,1,0,'2020-09-03 10:27:31','2020-09-12 15:20:13'),
	(452,0,'/0/','移动端管理',5,'/javaMobile','mobile-phone',1,0,'2020-09-07 11:21:03','2020-09-12 15:18:48'),
	(454,100,'/0/100/','99Api',6,'99Api','122',1,4,'2020-09-08 12:17:36','2020-09-08 12:18:44'),
	(459,118,'/0/118/','秒杀管理',5,'/marketing/seckill',NULL,1,0,'2020-09-17 10:02:39','2020-09-17 10:02:39'),
	(460,459,'/0/118/459/','秒杀配置',5,'/marketing/seckill/config',NULL,1,0,'2020-09-17 10:37:42','2020-09-17 10:41:30'),
	(461,459,'/0/118/459/','秒杀商品',5,'/marketing/seckill/list',NULL,1,0,'2020-09-17 10:38:27','2020-09-17 10:41:40'),
	(464,0,'/0/','财务',5,'/financial','s-finance',1,1,'2020-09-17 14:34:44','2020-09-17 14:34:44'),
	(465,464,'/0/464/','财务操作',5,'/financial/commission',NULL,1,0,'2020-09-17 14:35:37','2020-09-17 14:35:37'),
	(466,465,'/0/464/465/','申请提现',5,'/financial/commission/template',NULL,1,0,'2020-09-17 14:36:04','2020-09-17 14:36:04'),
	(467,464,'/0/464/','财务记录',5,'/financial/record',NULL,1,0,'2020-09-17 14:36:40','2020-09-17 14:36:40'),
	(468,467,'/0/464/467/','充值记录',5,'/financial/record/charge',NULL,1,0,'2020-09-17 14:36:55','2020-09-17 14:37:22'),
	(469,467,'/0/464/467/','资金监控',5,'/financial/record/monitor',NULL,1,0,'2020-09-17 14:37:35','2020-09-17 14:37:35'),
	(470,464,'/0/464/','佣金记录',5,'/financial/brokerage',NULL,1,0,'2020-09-17 14:38:16','2020-09-17 14:38:16'),
	(477,477,'/0/477/','22222',1,'','crmebimage/content/2020/10/19/6c8ba5e093384f589d212ff77e898d39kpfzjv8h3c.png',1,999999999,'2020-10-20 14:44:07','2021-01-25 10:02:25'),
	(488,245,'/0/272/245/','精品首发',1,'','crmebimage/store/2021/02/25/e15f9a3d323243f09b794a9f3eb92e395b64y3y4zv.jpg',1,0,'2020-10-21 10:19:17','2021-02-25 19:42:36'),
	(492,118,'/0/118/','砍价管理',5,'/marketing/bargain',NULL,1,0,'2020-11-16 12:29:25','2020-11-16 12:29:25'),
	(493,492,'/0/118/492/','砍价商品',5,'/marketing/bargain/bargainGoods',NULL,1,0,'2020-11-16 14:19:46','2020-11-16 14:19:46'),
	(494,492,'/0/118/492/','砍价列表',5,'/marketing/bargain/bargainList',NULL,1,0,'2020-11-16 14:38:57','2020-11-16 14:38:57'),
	(495,118,'/0/118/','拼团管理',5,'/marketing/groupBuy',NULL,1,0,'2020-11-19 14:06:51','2020-11-19 14:06:51'),
	(496,495,'/0/118/495/','拼团商品',5,'/marketing/groupBuy/groupGoods',NULL,1,0,'2020-11-19 14:07:32','2020-11-19 14:07:32'),
	(497,495,'/0/118/495/','拼团列表',5,'/marketing/groupBuy/groupList',NULL,1,0,'2020-11-19 14:07:57','2020-11-19 14:07:57'),
	(500,0,'/0/','第三方接口设置',6,'short_letter_switch',NULL,1,1,'2020-12-10 10:58:25','2020-12-10 10:59:39'),
	(501,500,'/0/500/','短信配置',6,'short_letter_switch','111',1,1,'2020-12-10 10:59:08','2020-12-10 12:05:54'),
	(502,500,'/0/500/','采集商品配置',6,'copy_product','127',1,1,'2020-12-10 11:00:32','2020-12-10 12:18:38'),
	(503,500,'/0/500/','物流查询',6,'logistics_select','128',1,1,'2020-12-10 11:00:51','2020-12-10 12:18:57'),
	(504,500,'/0/500/','电子面单',6,'electronic_sheet','129',1,1,'2020-12-10 11:01:03','2020-12-10 12:19:02'),
	(505,51,'/0/51/','一号通',5,'/operation/onePass',NULL,1,8,'2020-12-10 11:06:44','2020-12-10 11:07:46'),
	(506,0,'/0/','行业资讯',3,'','crmebimage/maintain/2021/08/13/b10e35efcea44519917fee68b01dddefbv695wjl03.jpg',1,0,'2020-12-15 17:45:43','2021-08-25 15:58:15'),
	(515,0,'/0/','每日新品',1,'','crmebimage/store/2021/02/25/fc6bbd39a9c244a8b8697ec74b096258ltkiim3ias.png',1,10,'2020-12-22 09:16:27','2021-02-25 19:45:04'),
	(528,66,'/0/66/','素材管理',5,'/maintain/picture',NULL,1,1,'2021-01-23 11:28:28','2021-01-23 11:29:19'),
	(534,515,'/0/515/','玩偶',1,'','crmebimage/store/2021/02/25/1a6318ea870043eba1daec9bdcc2b998a5tuyn7gsj.jpg',1,4,'2021-01-30 18:40:49','2021-02-25 19:41:34'),
	(540,54,'/0/51/52/54/','管理员状态更新',5,'api/admin/system/admin/updateStatus',NULL,0,0,'2021-02-04 10:59:10','2021-02-04 10:59:17'),
	(541,55,'/0/51/52/55/','权限列表',5,'api/admin/category/list',NULL,0,0,'2021-02-04 11:06:43','2021-02-04 11:06:43'),
	(542,55,'/0/51/52/55/','权限新增',5,'api/admin/category/save',NULL,0,0,'2021-02-04 11:08:11','2021-02-04 11:08:11'),
	(543,55,'/0/51/52/55/','权限删除',5,'api/admin/category/delete',NULL,0,0,'2021-02-04 11:11:16','2021-02-04 11:11:16'),
	(544,55,'/0/51/52/55/','权限更新',5,'api/admin/category/update',NULL,0,0,'2021-02-04 11:11:49','2021-02-04 11:11:49'),
	(546,55,'/0/51/52/55/','更新权限状态',5,'api/admin/category/updateStatus',NULL,0,0,'2021-02-04 11:14:19','2021-02-04 11:14:19'),
	(547,505,'/0/51/505/','一号通登录',5,'api/admin/pass/login',NULL,0,0,'2021-02-04 11:27:13','2021-02-04 11:27:13'),
	(548,505,'/0/51/505/','一号通注销',5,'api/admin/pass/logout',NULL,0,0,'2021-02-04 11:28:06','2021-02-04 11:28:06'),
	(549,505,'/0/51/505/','一号通修改密码',5,'api/admin/pass/update/password',NULL,0,0,'2021-02-04 11:28:33','2021-02-04 11:28:33'),
	(550,505,'/0/51/505/','一号通修改手机号码',5,'api/admin/pass/update/phone',NULL,0,0,'2021-02-04 11:29:02','2021-02-04 11:29:02'),
	(551,505,'/0/51/505/','一号通获取验证码',5,'api/admin/pass/sendUserCode',NULL,0,0,'2021-02-04 11:30:38','2021-02-04 11:30:38'),
	(552,80,'/0/51/80/','系统设置保存',5,'api/admin/system/config/save/form',NULL,0,0,'2021-02-04 11:37:51','2021-02-04 11:37:51'),
	(553,505,'/0/51/505/','修改短信签名',5,'api/admin/sms/modify/sign',NULL,0,0,'2021-02-04 11:43:36','2021-02-04 11:43:36'),
	(554,505,'/0/51/505/','短信模板',5,'api/admin/sms/temps',NULL,0,0,'2021-02-04 11:47:24','2021-02-04 11:47:24'),
	(555,505,'/0/51/505/','申请短信模板',5,'api/admin/sms/temp/apply',NULL,0,0,'2021-02-04 11:47:52','2021-02-04 11:47:52'),
	(556,505,'/0/51/505/','模板申请记录',5,'api/admin/sms/applys',NULL,0,0,'2021-02-04 11:48:41','2021-02-04 11:48:41'),
	(558,44,'/0/42/44/','和权限共用api',5,'',NULL,0,0,'2021-02-04 12:10:01','2021-02-04 12:10:01'),
	(559,49,'/0/47/49/','用户标签删除',5,'api/admin/user/tag/delete',NULL,0,0,'2021-02-04 15:37:48','2021-02-04 15:37:48'),
	(561,164,'/0/47/164/','用户分组新增',5,'api/admin/user/group/save',NULL,0,0,'2021-02-04 16:16:35','2021-02-04 16:16:35'),
	(562,57,'/0/56/57/','文章列表',5,'api/admin/article/list',NULL,0,0,'2021-02-04 16:27:49','2021-02-04 16:27:49'),
	(563,468,'/0/464/467/468/','充值记录列表',5,'api/admin/user/topUpLog/list',NULL,0,0,'2021-02-04 17:02:14','2021-02-04 17:02:14'),
	(564,468,'/0/464/467/468/','充值记录删除',5,'api/admin/user/topUpLog/delete',NULL,0,0,'2021-02-04 17:03:39','2021-02-04 17:03:39'),
	(581,528,'/0/66/528/','删除素材',5,'api/admin/system/attachment/delete',NULL,0,0,'2021-02-04 17:34:29','2021-02-04 17:35:23'),
	(582,66,'/0/66/','申请授权',5,'/maintain/authCRMEB',NULL,1,0,'2021-02-25 19:04:23','2021-02-25 19:11:20'),
	(583,139,'/0/113/139/','小程序订阅消息',5,'/appSetting/publicRoutine/template/0',NULL,1,0,'2021-03-08 12:05:22','2021-03-08 12:05:22'),
	(584,100,'/0/100/','app配置',6,'app配置','134',1,1,'2021-03-24 16:17:15','2021-03-24 16:17:30'),
	(585,103,'/0/103/','微信APP支付',6,'微信APP支付','135',1,1,'2021-03-24 16:25:11','2021-08-25 12:20:50'),
	(586,118,'/0/118/','视频号管理',5,'/marketing/videoChannel',NULL,1,0,'2021-05-20 09:27:26','2021-05-20 09:27:26'),
	(587,586,'/0/118/586/','商品列表',5,'/marketing/videoChannel/list',NULL,1,0,'2021-05-20 09:43:23','2021-05-21 14:53:08'),
	(588,586,'/0/118/586/','草稿列表',5,'/marketing/videoChannel/draftList',NULL,1,0,'2021-05-21 14:54:28','2021-05-21 14:54:28'),
	(589,0,'/0/','新闻时事',3,'','crmebimage/maintain/2021/08/11/c3f71b0f73234dbe8a041524809e92f6f4awpin8zc.png',1,1,'2021-06-15 17:19:24','2021-08-25 15:59:07'),
	(590,0,'/0/','金刚区',2,'url',NULL,0,1,'2021-07-06 19:27:36','2021-07-06 19:27:36'),
	(592,0,'/0/','LOGO',2,'url',NULL,0,1,'2021-07-13 09:41:23','2021-07-13 09:41:23'),
	(593,51,'/0/51/','页面管理',5,'/operation/design',NULL,1,0,'2021-07-20 16:06:20','2021-08-25 13:57:37'),
	(594,593,'/0/51/593/','一键换色',5,'/operation/design/theme',NULL,1,0,'2021-07-20 16:06:46','2021-07-20 16:06:46'),
	(595,593,'/0/51/593/','页面设计',5,'/operation/design/viewDesign',NULL,1,0,'2021-07-20 16:07:11','2021-07-20 16:07:11'),
	(596,595,'/0/51/593/595/','首页banner保存',5,'api/admin/page/layout/index/banner/save',NULL,0,0,'2021-07-20 16:16:44','2021-07-20 16:16:44'),
	(597,595,'/0/51/593/595/','新闻简报保存',5,'api/admin/page/layout/index/news/save',NULL,0,0,'2021-07-20 16:17:15','2021-07-20 16:17:15'),
	(598,595,'/0/51/593/595/','金刚区保存',5,'api/admin/page/layout/index/menu/save',NULL,0,0,'2021-07-20 16:17:46','2021-07-20 16:17:46'),
	(601,103,'/0/103/','支付宝支付(h5/App)',6,'支付宝支付(h5/App)','137',1,1,'2021-08-25 09:58:59','2021-08-25 12:22:49'),
	(602,51,'/0/51/','发货设置',5,'/operation/deliverGoods',NULL,1,1,'2021-08-25 11:16:29','2021-08-25 11:31:13'),
	(603,602,'/0/51/602/','提货设置',5,'/operation/deliverGoods/takeGoods',NULL,1,0,'2021-08-25 11:16:59','2021-08-25 11:16:59'),
	(604,602,'/0/51/602/','运费模板',5,'/operation/deliverGoods/freightSet',NULL,1,0,'2021-08-25 11:19:13','2021-08-25 11:19:13'),
	(605,603,'/0/51/602/603/','提货点',5,'/operation/deliverGoods/takeGoods/deliveryAddress',NULL,1,0,'2021-08-25 11:21:47','2021-08-25 11:21:47'),
	(607,603,'/0/51/602/603/','核销订单',5,'/operation/deliverGoods/takeGoods/collateOrder',NULL,1,0,'2021-08-25 11:22:30','2021-08-25 11:22:30'),
	(608,603,'/0/51/602/603/','核销员',5,'/operation/deliverGoods/takeGoods/collateUser',NULL,1,0,'2021-08-25 11:22:48','2021-08-25 11:22:48'),
	(609,66,'/0/66/','物流设置',5,'/maintain/logistics',NULL,1,0,'2021-08-25 11:26:39','2021-08-25 11:26:39'),
	(610,609,'/0/66/609/','城市数据',5,'/maintain/logistics/cityList',NULL,1,0,'2021-08-25 11:27:04','2021-08-25 11:27:04'),
	(612,609,'/0/66/609/','物流公司',5,'/maintain/logistics/companyList',NULL,1,0,'2021-08-25 11:27:46','2021-08-25 11:27:46'),
	(613,95,'/0/95/','APP升级配置',6,'APP upgrade','138',1,1,'2021-08-25 12:08:50','2021-08-25 12:08:50'),
	(614,81,'/0/81/','物流设置',6,'Logistics configuration','74',1,1,'2021-08-25 12:13:00','2021-08-25 12:13:00'),
	(619,245,'/0/272/245/','耐克',1,'','crmebimage/maintain/2021/04/30/10947a963ca04408a2e2c7ef730cf771kw84thv3zz.png',1,0,'2021-08-27 17:37:09','2021-08-27 17:37:09'),
	(620,245,'/0/272/245/','阿迪',1,'','crmebimage/maintain/2021/04/30/5223c2dd64ab4517bab59f9b9b473cd07t0sa4uksx.png',1,0,'2021-08-27 17:37:54','2021-08-27 17:37:54'),
	(621,245,'/0/272/245/','联想',1,'','crmebimage/maintain/2021/04/30/2d1e3f9c640c42259988c1f2ba097cab1l9rwd6k8o.png',1,0,'2021-08-27 17:38:17','2021-08-27 17:38:17'),
	(622,245,'/0/272/245/','Apple',1,'','crmebimage/maintain/2021/04/30/efbfa787584446e4b412d4c4ec1b8c46qcoju9m76v.png',1,0,'2021-08-27 17:38:39','2021-08-27 17:38:39'),
	(631,0,'/0/','CRMEB行业动态',3,'','crmebimage/maintain/2021/07/07/241e9f8065354fd295d3c626d9ccf492984lsgwqwh.png',1,0,'2021-09-10 14:20:48','2021-09-10 14:28:40'),
	(632,0,'/0/','统计管理',5,'/statistic','s-data',1,0,'2021-09-18 11:26:22','2021-09-18 11:26:22'),
	(633,632,'/0/632/','商品统计',5,'/statistic/product',NULL,1,0,'2021-09-18 11:26:49','2021-09-18 11:26:49'),
	(634,632,'/0/632/','用户统计',5,'/statistic/statuser',NULL,1,0,'2021-09-18 11:27:35','2021-09-18 11:27:35'),
	(635,632,'/0/632/','交易统计',5,'/statistic/transaction',NULL,1,0,'2021-09-18 11:27:54','2021-09-18 11:27:54'),
	(636,633,'/0/632/633/','统计',5,'/statistic/product/visualization',NULL,1,0,'2021-09-18 11:28:19','2021-09-18 11:28:19'),
	(637,633,'/0/632/633/','商品排行',5,'/statistic/product/tableData',NULL,1,0,'2021-09-18 11:28:34','2021-09-18 11:28:34'),
	(638,0,'/0/','国庆节',2,'url',NULL,0,1,'2021-09-22 14:53:45','2021-09-22 14:53:45'),
	(639,638,'/0/638/','国庆-banner',2,'url',NULL,0,1,'2021-09-22 14:57:22','2021-09-22 14:57:22'),
	(641,638,'/0/638/','国庆-tabbar',2,'url',NULL,0,1,'2021-09-22 14:58:23','2021-09-22 14:58:23'),
	(642,638,'/0/638/','国庆-nav',2,'url',NULL,0,1,'2021-09-22 14:59:15','2021-09-22 14:59:15'),
	(643,642,'/0/638/642/','国庆-nav1',2,'url',NULL,0,1,'2021-09-22 14:59:51','2021-09-22 14:59:51'),
	(645,642,'/0/638/642/','国庆-nav2',2,'url',NULL,0,1,'2021-09-22 15:00:41','2021-09-22 15:00:41'),
	(664,500,'/0/500/','统计',6,'crmeb_tongji','141',1,1,'2020-09-22 09:03:34','2020-09-22 09:03:34'),
	(665,595,'/0/51/593/595/','个人菜单',5,'api/admin/page/layout/user/menu/save',NULL,0,0,'2021-09-24 11:20:54','2021-09-24 11:21:45'),
	(666,595,'/0/51/593/595/','个人banner',5,'api/admin/page/layout/user/banner/save',NULL,0,0,'2021-09-24 11:23:05','2021-09-24 11:23:05'),
	(667,595,'/0/51/593/595/','分类页样式',5,'api/admin/page/layout/category/config/save',NULL,0,0,'2021-09-24 11:24:11','2021-09-24 11:24:11'),
	(668,595,'/0/51/593/595/','首页活动tab',5,'api/admin/page/layout/index/table/save',NULL,0,0,'2021-09-24 11:25:14','2021-09-24 11:25:14'),
	(669,148,'/0/146/148/','分销配置api',5,'api/admin/store/retail/spread/manage/set',NULL,0,0,'2021-09-24 11:26:19','2021-09-24 11:26:19'),
	(670,605,'/0/51/602/603/605/','删除提货点',5,'api/admin/system/store/delete',NULL,0,0,'2021-09-24 11:28:21','2021-09-24 11:28:21'),
	(671,608,'/0/51/602/603/608/','核销员删除',5,'api/admin/system/store/staff/delete',NULL,0,0,'2021-09-24 11:30:35','2021-09-24 11:30:35'),
	(672,604,'/0/51/602/604/','删除',5,'api/admin/express/shipping/templates/delete',NULL,0,0,'2021-09-24 11:32:54','2021-09-24 11:32:54'),
	(673,0,'/0/','个人中心导航素材',2,'url',NULL,0,1,'2021-09-24 11:47:20','2021-09-24 11:47:20'),
	(674,0,'/0/','等级图标',2,'url',NULL,0,1,'2021-10-13 17:15:33','2021-10-13 17:15:33'),
	(676,461,'/0/118/459/461/','秒杀更改状态',5,'api/admin/store/seckill/update/status',NULL,0,0,'2021-10-30 09:21:12','2021-10-30 09:24:44'),
	(678,460,'/0/118/459/460/','秒杀配置开关',5,'api/admin/store/seckill/manger/update/statu',NULL,0,0,'2021-10-30 10:47:18','2021-10-30 10:47:18'),
	(679,496,'/0/118/495/496/','拼团商品状态',5,'api/admin/store/combination/update/status',NULL,0,0,'2021-10-30 10:52:24','2021-10-30 10:52:30'),
	(680,493,'/0/118/492/493/','砍价商品状态',5,'api/admin/store/bargain/update/status',NULL,0,0,'2021-10-30 10:55:58','2021-10-30 10:55:58'),
	(681,515,'/0/515/','日用',1,'','crmebimage/public/store/2021/10/28/ea02376e91584f479397cce802eec9f01h2xmypn7r.jpg',1,0,'2021-11-02 10:27:23','2021-11-02 10:27:23');
